<?php       
function lista_reservas($mysqli){
    ?>	
    <div class="page-title-box d-flex align-items-center justify-content-between">
		<h4 class="mb-0">Reserva de vehículos</h4>
		<div class="page-title-right">
			<ol class="breadcrumb m-0">
				<li class="breadcrumb-item"><a href="<?_GetDomain?>index.php">Escritorio</a></li>
				<li class="breadcrumb-item active">Reserva de vehículos</li>
			</ol>
		</div>
	</div>
    <div class="content-body">
        <div class="row">
            <div class="col-12">
                <div class="card">						
                    <div class="card-content">
                        <div class="card-body card-dashboard">
                            <table width="100%" border="0">
                            <tr>
                                <td><p class="card-text">Información de reserva de vehículos</p></td>
                                <td align="right"> </td>
                            </tr>
                            </table>

                        </div>
                        <div class="table-responsive">
                            <table id="datatable" class="table table-bordered mb-0">
                                <thead>
                                    <tr>
									    <th width="1%"  style="padding: 5px; font-size:11px">#</th>
										<th width="3%"  style="padding: 5px; font-size:11px">Res</th>			
										<th width="6%"  style="padding: 5px; font-size:11px">Fecha</th>
										<th width="7%" style="padding: 5px; font-size:11px">Cliente</th>
										<th width="7%" style="padding: 5px; font-size:11px">Teléfono</th>
                                        <th width="6%" style="padding: 5px; font-size:11px">Imagen</th>
                                        <th width="7%" style="padding: 5px; font-size:11px">Vehículo</th>
                                        <th width="7%" style="padding: 5px; font-size:11px">F.inicio</th>
										<th width="7%" style="padding: 5px; font-size:11px">F.término</th>
										<th width="7%" style="padding: 5px; font-size:11px">Cant.días</th>
										<th width="7%" style="padding: 5px; font-size:11px">Valor día</th>
										<th width="7%" style="padding: 5px; font-size:11px">Descto</th>
										<th width="6%" style="padding: 5px; font-size:11px">Total</th>
										<th width="7%" style="padding: 5px; font-size:11px">E.Pago</th>
										<th width="9%" style="padding: 5px; font-size:11px">Estado</th>                                        																																
                                        <th width="7%" style="padding: 5px; font-size:11px">Acción</th>
                                    </tr>
                                </thead>
                                <tbody>
                                <?php
                                $i=1;
                                
								$rs = getReservas($mysqli);
								while ($rows = $rs->fetch_assoc()){
									$id_reserva = $rows['id_reserva'];
								    $fecha = $rows['fecha'];
									$hora  = $rows['hora'];
									$id_vehiculo = $rows['id_vehiculo'];
									$nombre   = $rows['nombre'];
									$telefono = $rows['telefono'];
									$fecha_ini = $rows['fecha_ini'];
									$fecha_fin = $rows['fecha_fin'];
									$cant_dias = $rows['cant_dias'];
									$valor_total = $rows['valor_total'];
									$valor_dia = $rows['valor_dia'];
									$estado_pago = $rows['estado_pago'];
									$estado_entrega = $rows['estado_entrega'];
									$descuento = $rows['descuento'];

									$sql2 = getVehiculosById($mysqli, $id_vehiculo);
									$rows2 = $sql2->fetch_assoc();
									$foto1 = $rows2['foto1'];
									$marca = $rows2['marca'];
									$modelo = $rows2['modelo'];

									if ($estado_pago==1){
										$txt_estado_pago = "Pagado";
									}else{
										$txt_estado_pago = "No pagado";
									}
									if ($estado_entrega==0){
										$txt_estado_entrega = "No entregado";
									}
									if ($estado_entrega==1){
										$txt_estado_entrega = "Entregado";
									}
									if ($estado_entrega==2){
										$txt_estado_entrega = "Devuelto";
									}
									if ($estado_entrega==3){
										$txt_estado_entrega = "Cancelada";
									}
									?>
                                    <tr>
									    <td style="padding: 5px; font-size:11px"><?=$i?></td>
									    <td align="center" style="padding: 5px; font-size:11px"><?=$id_reserva?></td>
									    <td style="padding: 5px; font-size:11px"><?=$fecha?> <?=$hora?></td>
										<td style="padding: 5px; font-size:11px"><?=$nombre?></td>
										<td style="padding: 5px; font-size:11px"><?=$telefono?></td>                                        
                                        <td style="padding: 5px; font-size:11px"><img src="../vehiculos/prod/<?=$foto1?>" width="50px"></td>
                                        <td style="padding: 5px; font-size:11px"><?=$marca?> <?=$modelo?></td>
                                        <td style="padding: 5px; font-size:11px"><?=fecha_esp($fecha_ini)?></td>
                                        <td style="padding: 5px; font-size:11px"><?=fecha_esp($fecha_fin)?></td>
                                        <td align="center" style="padding: 5px; font-size:11px"><?=$cant_dias?></td>
										<td align="right" style="padding: 5px; font-size:11px"><?=formatear($valor_dia)?></td>
										<td align="right" style="padding: 5px; font-size:11px"><?=formatear($descuento)?></td>
										<td align="right" style="padding: 5px; font-size:11px"><?=formatear($valor_total)?></td>
										<td style="padding: 5px; font-size:11px"><?=$txt_estado_pago?></td>
										<td style="padding: 5px; font-size:11px"><?=$txt_estado_entrega?></td>											
                                        <td align="center" style="padding: 5px; font-size:11px">                                       
                                            <a href="formulario.php?p=1&id=<?=$id_reserva?>" class="btn btn-warning" style="padding:3px" title="Editar"> <i class="ri-pencil-fill"></i></a>
											<?php
										    if ($estado_entrega==3){ ?>
											    &nbsp;<a href="#" class="btn btn-danger"  style="padding: 3px;" title="Eliminar" data-bs-toggle="modal" data-bs-target="#myModal<?=$i?>"><i class="ri-delete-bin-line"></i></a> 
									      <? } ?>		                                     		
                                        </td>
                                    </tr>
									<div id="myModal<?=$i?>" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel<?=$i?>" aria-hidden="true">
										<div class="modal-dialog" role="document">
											<div class="modal-content">
											<div class="modal-header">
												<h5 class="modal-title">Eliminar reserva</h5>
												<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>														
											</div>
											<div class="modal-body">
												<p>¿Está seguro de eliminar este registro?</p>
											</div>
											<div class="modal-footer">
												<button type="button" class="btn btn-danger" data-bs-dismiss="modal" onclick="proc_elim(1,'<?=$id_reserva?>')">Si, eliminar</button>
												<button type="button" class="btn btn-light waves-effect" data-bs-dismiss="modal">Cerrar</button>
											</div>
											</div>
										</div>
									</div>
									<?php
									$i++;
								}
								?>	                                    											
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php
} 

function formulario_reserva($mysqli, $id){

	if ($id>0){
		$sql = $mysqli->query("select * from tb_reservas where id_reserva='".$id."' ");
		$rows = $sql->fetch_assoc();
		$fecha = $rows['fecha'];
		$hora = $rows['hora'];
		$id_vehiculo = $rows['id_vehiculo'];
		$nombre = $rows['nombre'];
		$email = $rows['email'];
		$pais = $rows['pais'];
		$telefono = $rows['telefono'];
		$fecha_ini = $rows['fecha_ini'];
		$fecha_fin = $rows['fecha_fin'];
		$observaciones = $rows['observaciones'];
		$valor_dia = $rows['valor_dia'];
		$cant_dias = $rows['cant_dias'];
		$valor_total = $rows['valor_total'];
		$estado_pago = $rows['estado_pago'];
		$estado_entrega = $rows['estado_entrega'];

		$rs = getVehiculosById($mysqli, $id_vehiculo);
		$rows = $rs->fetch_assoc();
		
		$nombre_veh = $rows['nombre'];
		$color = $rows['color'];
		$marca = $rows['marca'];
		$modelo = $rows['modelo'];
		$ano = $rows['ano'];
		$carga = $rows['carga'];
		$foto1 = $rows['foto1'];
	}   
	?>	
	<div class="page-title-box d-flex align-items-center justify-content-between">
		<h4 class="mb-0">Reserva de vehículo</h4>
		<div class="page-title-right">
			<ol class="breadcrumb m-0">
				<li class="breadcrumb-item"><a href="../index.php">Escritorio</a></li>
				<li class="breadcrumb-item active">Reserva</li>
			</ol>
		</div>
	</div>
        <div class="content-body"><!-- Description -->
	
	
	      <div class="col-md-10 offset-1">
			<div class="card">
				
				<div class="card-content collapse show">
					<div class="card-body">
						<div class="card-text">
							<p>Información de reserva de vehículo</p>
						</div>
						<form class="m-t" role="form" action="act.php" method="post" enctype="multipart/form-data">
						   <input type="hidden" name="id" id="id" value="<?=$id?>">
						   <input type="hidden" name="tb_cc" id="tb_cc" value="1">						
						   <div class="form-actions" align="right"></div>						
							 <div class="form-body">
							    <div class="form-group  row"><label class="col-sm-3 col-form-label">Datos del cliente</label>
									<div class="col-sm-9"></div>
								</div>														
								<div class="form-group  row">
									<label class="col-sm-2 ">Nombre</label>
									<label class="col-sm-4"><?=$nombre?></label>
								    <label class="col-sm-2 ">E-mail</label>
									<label class="col-sm-4"><?=$email?></label>
								</div>
								<div class="form-group  row" style="margin-top: 10px;">
								    <label class="col-sm-2">Teléfono</label>
									<div class="col-sm-4"><?=$telefono?></div>
								    <label class="col-sm-2 ">País</label>
									<div class="col-sm-4"><?=$pais?></div>
								</div>
								<div class="form-group  row" style="margin-top: 10px;">
								    <label class="col-sm-2 ">Observaciones</label>
									<div class="col-sm-10"><?=$observaciones?></div>								    
								</div>
								<div class="form-group  row"><label class="col-sm-6 col-form-label">Datos de la reserva</label>
									<div class="col-sm-6"></div>
								</div>
								<div class="form-group  row" style="margin-top: 10px;">
								    <label class="col-sm-2 ">Vehículo</label>
									<div class="col-sm-10"><?=$nombre_veh?></div>
								</div>				
								<div class="form-group  row" style="margin-top: 10px;">
								    <label class="col-sm-2 ">Foto1</label>
									<div class="col-sm-10"><? if ($foto1!=NULL){ ?><img src="../vehiculos/prod/<?=$foto1?>" width="100px"><? } ?></div>
								</div>
								<div class="form-group  row" style="margin-top: 10px;">
								    <label class="col-sm-2 ">Valor día</label>
									<div class="col-sm-10"><?=$valor_dia?></div>
								</div>
								<div class="form-group  row" style="margin-top: 10px;">
								    <label class="col-sm-2 ">Fecha de inicio</label>
									<div class="col-sm-4"><?=fecha_esp($fecha_ini)?></div>
									<label class="col-sm-2 ">Fecha de entrega</label>
									<div class="col-sm-4"><?=fecha_esp($fecha_fin)?></div>
								</div>
								<div class="form-group  row" style="margin-top: 10px;">
								    <label class="col-sm-2 ">Cantidad días</label>
									<div class="col-sm-2"><?=$cant_dias?></div>
									<label class="col-sm-2 ">Descuento</label>
									<div class="col-sm-2"><?=$cant_dias?></div>
									<label class="col-sm-2 ">Valor total</label>
									<div class="col-sm-2"><?=$valor_total?></div>
								</div>
								<div class="form-group  row" style="margin-top: 10px;">
								    <label class="col-sm-2 ">Estado de pago</label>
									<div class="col-sm-4">
										<select name="pagado" id="pagado" class="form-control">											
											<option value="0" <?php if ($estado_pago==0){ ?> selected <? } ?>>No pagado</option>
											<option value="1" <?php if ($estado_pago==1){ ?> selected <? } ?>>pagado</option>											
										</select>
									</div>
								</div>
								<div class="form-group  row" style="margin-top: 10px;">
								    <label class="col-sm-2 ">Estado</label>
									<div class="col-sm-4">
										<select name="entrega" id="entrega" class="form-control">											
											<option value="0" <?php if ($estado_entrega==0){ ?> selected <? } ?>>No entregado</option>
											<option value="1" <?php if ($estado_entrega==1){ ?> selected <? } ?>>Entregado</option>
											<option value="2" <?php if ($estado_entrega==2){ ?> selected <? } ?>>Devuelto</option>
											<option value="3" <?php if ($estado_entrega==3){ ?> selected <? } ?>>Cancelada</option>
										</select>
									</div>
								</div>												
							</div>
							<br><br>
							<div class="form-actions" align="right">
                                <a href="index.php?p=1" class="btn btn-warning"><i class="ft-x"></i> Volver</a> 						
								<button type="submit" class="btn btn-success">
									<i class="fa fa-check"></i> Grabar
								</button>
							</div>
						</form>
					</div>
				</div>
			</div>
		</div>	
		</div>
     	
	<?php

}

function lista_sucursales($mysqli){
    ?>
  
			<div class="content-header row">
			  <div class="content-header-left col-md-6 col-12 mb-1">
				<h3 class="content-header-title">Sucursales de la empresa</h3>
			  </div>          
			</div>
			<div class="content-body"><!-- Description -->

			 <div class="row">
					<div class="col-12">
						<div class="card">						
							<div class="card-content">
								<div class="card-body card-dashboard">
								   <table width="100%" border="0">
									<tr>
										<td><p class="card-text">Información de sucursales</p></td>
										<td align="right">
                                           <a href="formulario.php?p=2" class="btn btn-info">+ Nueva</a>								
										</td>
									</tr>
								   </table>

								</div>
								<div class="table-responsive">
									<table class="table table-bordered mb-0">
										<thead>
											<tr>											
											    
											    <th>Nombre</th>												
												<th>Dirección</th>												
												<th>Teléfono</th>
												<th>Región</th>
                                                <th>Comuna</th>
																																
												<th width="5%">Acción</th>
											</tr>
										</thead>
										<tbody>
										<?php
										$i=1;
										$sql = $mysqli->query("select * from tb_sucursal");
										while ($rows = $sql->fetch_assoc()){
											$id_sucursal    = $rows['id_sucursal'];
											$nombre         = $rows['nombre'];
											$direccion      = $rows['direccion'];
											$id_comuna      = $rows['id_comuna'];
											$id_region      = $rows['id_region'];
											$telefono       = $rows['telefono'];
											
											$sql2 = $mysqli->query("select * from tb_regiones where id_region='$id_region'");
											$rows2 = $sql2->fetch_assoc();
											$nombre_region = $rows2['nombre'];

											$sql2 = $mysqli->query("select * from tb_comunas where id_comuna='$id_comuna'");
											$rows2 = $sql2->fetch_assoc();
											$nombre_comuna = $rows2['nombre'];
											?>
											<tr>												
											    
											    <td><?=$nombre?></td>
												<td align="center"><?=$direccion?></td>
												<td><?=$telefono?></td>
												<td><?=$nombre_region?></td>
                                                <td><?=$nombre_comuna?></td>											
												<td align="center">												
                                                    <a href="formulario.php?p=2&id=<?=$id_sucursal?>" class="btn btn-warning"  style="padding: 6px;">Editar</a>
												</td>
											</tr>
									        <?php 
										  $i++;	

										} ?>												
										</tbody>
									</table>
								</div>
							</div>
						</div>
					</div>
				</div>

			</div>
		  
        <?php  
}


?>          
